#!/bin/bash

echo ">>> Haushaltsbuch / FinanzPlaner Installations-Skript <<<"
echo "Versuche, die Linux-Distribution zu erkennen..."

# --- Schritt 1: Distribution erkennen und System-Pakete installieren ---

if [ -f /etc/os-release ]; then
    . /etc/os-release
else
    echo "Fehler: /etc/os-release nicht gefunden. Kann die Distribution nicht bestimmen."
    exit 1
fi

if [[ "$ID" == "debian" || "$ID" == "ubuntu" || "$ID_LIKE" == "debian" ]]; then
    echo "--> Debian/Ubuntu-basiertes System erkannt."
    echo "--> Installiere Abhängigkeiten via APT (sudo-Passwort wird benötigt)..."
    sudo apt update
    sudo apt install -y \
        python3 python3-pip \
        python3-gi python3-gi-cairo \
        gir1.2-gtk-4.0 gir1.2-adw-1 \
        python3-reportlab \
        sqlite3

elif [ "$ID" == "void" ]; then
    echo "--> Void Linux erkannt."
    echo "--> Installiere Abhängigkeiten via XBPS (sudo-Passwort wird benötigt)..."
    sudo xbps-install -Sy \
        python3 python3-pip \
        python3-gobject \
        gtk4 libadwaita \
        python3-reportlab \
        sqlite

elif [ "$ID" == "fedora" ]; then
    echo "--> Fedora erkannt."
    echo "--> Installiere Abhängigkeiten via DNF (sudo-Passwort wird benötigt)..."
    sudo dnf install -y \
        python3 python3-pip \
        python3-gobject \
        gtk4 libadwaita \
        python3-reportlab \
        sqlite3

elif [[ "$ID" == "arch" || "$ID_LIKE" == "arch" ]]; then
    echo "--> Arch Linux-basiertes System erkannt."
    echo "--> Installiere Abhängigkeiten via Pacman (sudo-Passwort wird benötigt)..."
    sudo pacman -Syu --noconfirm
    sudo pacman -S --noconfirm \
        python python-pip \
        python-gobject \
        gtk4 libadwaita \
        python-reportlab \
        sqlite

elif [[ "$ID" == "opensuse-tumbleweed" || "$ID" == "opensuse-leap" || "$ID_LIKE" == "suse" ]]; then
    echo "--> openSUSE erkannt."
    echo "--> Installiere Abhängigkeiten via Zypper (sudo-Passwort wird benötigt)..."
    sudo zypper refresh
    sudo zypper install -y \
        python3-pip \
        python3-gobject \
        typelib-1_0-Gtk-4_0 \
        typelib-1_0-Adw-1 \
        python3-reportlab \
        sqlite3

elif [ "$ID" == "solus" ]; then
    echo "--> Solus erkannt."
    echo "--> Installiere Abhängigkeiten via eopkg (sudo-Passwort wird benötigt)..."
    sudo eopkg install -y \
        python3 \
        python-gobject \
        libgtk-4 \
        libadwaita \
        python-reportlab \
        sqlite3

else
    echo "Fehler: Diese Distribution ($ID) wird vom Skript nicht automatisch unterstützt."
    echo "Bitte installiere die Abhängigkeiten manuell (GTK4, libadwaita, PyGObject, ReportLab, sqlite3)."
    exit 1
fi

# --- Schritt 2: (optional) Python-Pakete per pip nachinstallieren ---

# Aktuell braucht das Haushaltsbuch nichts, was nicht schon als Paket existiert.
# Falls du später noch etwas per pip installieren willst, kannst du das hier tun.
# Beispiel:
# echo "--> Installiere zusätzliche Python-Pakete für den aktuellen Benutzer..."
# pip3 install --user --break-system-packages irgendwas

# --- Schritt 3: Lokale Skripte und Starter einrichten (für alle gleich) ---

echo "--> Mache Start-Skript ausführbar..."
chmod +x start.sh

echo "--> Erstelle und installiere Anwendungs-Starter..."

APP_DIR=$(pwd)
DESKTOP_FILE="$HOME/.local/share/applications/haushaltsbuch.desktop"

mkdir -p "$(dirname "$DESKTOP_FILE")"

cat << EOF > "$DESKTOP_FILE"
[Desktop Entry]
Version=1.0
Type=Application
Name=Haushaltsbuch (FinanzPlaner)
Comment=Modernes Haushaltsbuch & Budgetplanung
Exec=$APP_DIR/start.sh
Icon=app_icon
Terminal=false
Categories=Office;Finance;
StartupNotify=true
Tminal=false
Categories=Office;Finance;
EOF

echo "--> Installiere Icon..."

ICON_TARGET="$HOME/.local/share/icons/hicolor/512x512/apps"
mkdir -p "$ICON_TARGET"
cp "$APP_DIR/icons/app_icon.png" "$ICON_TARGET/app_icon.png"

# Icon-Cache aktualisieren (GNOME, XFCE, Cinnamon, MATE)
if command -v gtk-update-icon-cache >/dev/null 2>&1; then
    gtk-update-icon-cache -f "$HOME/.local/share/icons/hicolor"
fi

echo ""
echo ">>> Installation abgeschlossen! <<<"
echo "Du solltest 'Haushaltsbuch (FinanzPlaner)' jetzt in deinem Anwendungsmenü finden."
echo "(Eventuell musst du dich ab- und wieder anmelden, damit es erscheint.)"
