#!/bin/bash

# Farben für Ausgabe
GREEN='\033[0;32m'
BLUE='\033[0;34m'
RED='\033[0;31m'
NC='\033[0m' # No Color

# 1. Root-Rechte prüfen
if [ "$EUID" -ne 0 ]; then
  echo -e "${RED}Bitte führen Sie dieses Skript als Root aus (sudo ./install.sh)${NC}"
  exit 1
fi

echo -e "${BLUE}=== Void Linux Scanner Assistant Installer ===${NC}"

# 2. Abhängigkeiten installieren
echo -e "${GREEN}Installiere Abhängigkeiten via xbps...${NC}"
# python3-gobject, gtk4, libadwaita (GUI)
# sane (für scanimage), usbutils (für lsusb), polkit (für pkexec)
xbps-install -Sy python3 python3-gobject gtk4 libadwaita sane usbutils polkit

if [ $? -ne 0 ]; then
    echo -e "${RED}Fehler bei der Installation der Abhängigkeiten.${NC}"
    exit 1
fi

# Ziel-Verzeichnisse definieren
INSTALL_DIR="/usr/local/bin/void-linux-system-utility/scanner"
DESKTOP_DIR="/usr/share/applications"

# 3. Aufräumen & Ordnerstruktur erstellen
echo -e "${GREEN}Prüfe Zielverzeichnis...${NC}"

# Prüfen, ob Ordner existiert, und löschen (Clean Install)
if [ -d "$INSTALL_DIR" ]; then
    echo -e "${BLUE}Alte Installation in $INSTALL_DIR gefunden. Lösche und ersetze...${NC}"
    rm -rf "$INSTALL_DIR"
fi

# Ordner neu erstellen
echo "Erstelle Verzeichnis $INSTALL_DIR/icons ..."
mkdir -p "$INSTALL_DIR/icons"

# 4. Dateien kopieren
SCRIPT_NAME="scanner.py"

if [ -f "$SCRIPT_NAME" ]; then
    echo "Kopiere Skript..."
    cp "$SCRIPT_NAME" "$INSTALL_DIR/"
    chmod +x "$INSTALL_DIR/$SCRIPT_NAME"
else
    echo -e "${RED}Fehler: $SCRIPT_NAME nicht im aktuellen Ordner gefunden!${NC}"
    exit 1
fi

if [ -f "icons/scanner.png" ]; then
    echo "Kopiere Icon..."
    cp "icons/scanner.png" "$INSTALL_DIR/icons/"
else
    echo -e "${RED}Warnung: icons/scanner.png nicht gefunden.${NC}"
fi

if [ -f "scanner.desktop" ]; then
    echo "Kopiere Desktop-Shortcut..."
    cp "scanner.desktop" "$DESKTOP_DIR/"
    
    # 5. Pfade in der .desktop Datei automatisch anpassen
    echo "Passe Pfade in der .desktop Datei an..."
    # Wir nutzen | als Trennzeichen für sed, da Pfade / enthalten
    sed -i "s|Exec=.*|Exec=$INSTALL_DIR/$SCRIPT_NAME|" "$DESKTOP_DIR/scanner.desktop"
    sed -i "s|Icon=.*|Icon=$INSTALL_DIR/icons/scanner.png|" "$DESKTOP_DIR/scanner.desktop"
    
    # Rechte setzen
    chmod 644 "$DESKTOP_DIR/scanner.desktop"
else
    echo -e "${RED}Warnung: scanner.desktop nicht gefunden.${NC}"
fi

# Abschließende Berechtigungen sicherstellen
chown -R root:root "$INSTALL_DIR"

echo -e "${BLUE}=== Installation erfolgreich abgeschlossen! ===${NC}"
echo "Der Scanner-Assistent wurde nach $INSTALL_DIR installiert."
