import gi
gi.require_version("Gtk", "4.0")
from gi.repository import Gtk, Gdk

class InstallModeView(Gtk.Box):
    def __init__(self, on_next_callback):
        super().__init__(orientation=Gtk.Orientation.VERTICAL, spacing=12)
        self.on_next_callback = on_next_callback
        
        for s in (
            self.set_margin_top,
            self.set_margin_bottom,
            self.set_margin_start,
            self.set_margin_end,
        ):
            s(6)

        title = Gtk.Label.new(_("Installationsart wählen"))
        title.add_css_class("title-1")
        title.set_halign(Gtk.Align.START)
        self.append(title)

        subtitle = Gtk.Label.new(_("Wie soll Void Linux installiert werden?"))
        subtitle.set_halign(Gtk.Align.START)
        self.append(subtitle)

        # Container für die Karten
        cards_box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=12)
        cards_box.set_margin_top(20)
        self.append(cards_box)

        # Option 1: Live-Image (Offline)
        self.rb_live = Gtk.CheckButton.new_with_label("")
        self.rb_live.set_active(True)
        self.rb_live.connect("toggled", self._on_mode_changed)
        
        card_live = self._create_card(
            self.rb_live,
            "system-installer-symbolic",
            _("Live-System klonen (Offline)"),
            _("Kopiert das aktuelle Live-System 1:1 auf die Festplatte.\n"
              "• Schnellste Methode\n"
              "• Keine Internetverbindung nötig\n"
              "• Desktop-Umgebung ist bereits festgelegt (wie Live-ISO)")
        )
        cards_box.append(card_live)

        # Option 2: Netinstall (Online)
        self.rb_net = Gtk.CheckButton.new_with_label("")
        self.rb_net.set_group(self.rb_live) # Radio-Gruppe
        self.rb_net.connect("toggled", self._on_mode_changed)
        
        card_net = self._create_card(
            self.rb_net,
            "network-transmit-receive-symbolic",
            _("Neues System bauen (Online / Netinstall)"),
            _("Lädt Pakete frisch aus dem Internet herunter.\n"
              "• Aktuellste Versionen\n"
              "• Freie Auswahl der Desktop-Umgebung\n"
              "• Inklusive Include-Ordner Unterstützung")
        )
        cards_box.append(card_net)
        
        self.mode = "live" # Default

        # Spacer drückt die Icons nach ganz unten
        spacer = Gtk.Box()
        spacer.set_vexpand(True)
        self.append(spacer)

        icon_box = Gtk.Box(spacing=32)
        icon_box.set_halign(Gtk.Align.CENTER)
        icon_box.set_valign(Gtk.Align.END)
        icon_box.set_margin_bottom(20)

        # Icons
        icon_disk = Gtk.Image.new_from_icon_name("drive-harddisk-symbolic")
        icon_disk.set_pixel_size(120)
        icon_disk.add_css_class("page-illustration")
        icon_box.append(icon_disk)

        icon_net = Gtk.Image.new_from_icon_name("network-workgroup-symbolic")
        icon_net.set_pixel_size(120)
        icon_net.add_css_class("page-illustration")
        icon_box.append(icon_net)

        self.append(icon_box)

    def _create_card(self, radio, icon_name, title_text, desc_text):
        frame = Gtk.Frame()
        frame.add_css_class("card")
        frame.add_css_class("clickable-card")
        
        # Mauszeiger zur Hand machen
        frame.set_cursor(Gdk.Cursor.new_from_name("pointer", None))

        # Klick-Event für die Karte
        gesture = Gtk.GestureClick()
        gesture.connect("pressed", self._on_card_clicked, radio)
        frame.add_controller(gesture)
        
        box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=12)
        box.set_margin_top(12)
        box.set_margin_bottom(12)
        box.set_margin_start(12)
        box.set_margin_end(12)
        frame.set_child(box)

        # Radio button
        box.append(radio)

        # Icon
        icon = Gtk.Image.new_from_icon_name(icon_name)
        icon.set_pixel_size(48)
        icon.set_valign(Gtk.Align.CENTER)
        box.append(icon)

        # Text Box
        text_box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=4)
        box.append(text_box)

        title = Gtk.Label.new(title_text)
        title.add_css_class("heading")
        title.set_halign(Gtk.Align.START)
        text_box.append(title)

        desc = Gtk.Label.new(desc_text)
        desc.set_wrap(True)
        desc.set_halign(Gtk.Align.START)
        desc.add_css_class("dim-label")
        text_box.append(desc)

        return frame

    def _on_card_clicked(self, gesture, n_press, x, y, radio):
        # Den Radio-Button aktivieren
        radio.set_active(True)
        # Sofort weiter zur nächsten Seite
        if self.on_next_callback:
            self.on_next_callback()

    def _on_mode_changed(self, btn):
        if self.rb_live.get_active():
            self.mode = "live"
        else:
            self.mode = "net"

    def get_mode(self):
        return self.mode