import gi
import os
from gi.repository import Gtk, Gdk

gi.require_version("Gtk", "4.0")
from gi.repository import Gtk

__all__ = ["WelcomeView"]


class WelcomeView(Gtk.Box):
    def __init__(self, on_start_clicked): # on_start_clicked hinzufügen
        super().__init__(orientation=Gtk.Orientation.VERTICAL, spacing=0)
        self.on_start_clicked = on_start_clicked

        sc = Gtk.ScrolledWindow()
        sc.set_vexpand(True)
        sc.set_policy(Gtk.PolicyType.NEVER, Gtk.PolicyType.AUTOMATIC)
        self.append(sc)

        container = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=24)
        container.add_css_class("welcome-container")
        
        # Zentrierung für Responsivität
        container.set_halign(Gtk.Align.CENTER)
        # KORREKTUR: set_size_request statt set_width_request
        # 500 Pixel Breite, Höhe automatisch (-1)
        container.set_size_request(500, -1)
        
        for s in (container.set_margin_top, container.set_margin_bottom,
                  container.set_margin_start, container.set_margin_end):
            s(24)

        # --- HERO ---
        hero = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=12)
        hero.set_halign(Gtk.Align.CENTER)
        
        hero_icon = Gtk.Image.new_from_icon_name("computer-symbolic")
        hero_icon.set_pixel_size(80)
        hero_icon.add_css_class("welcome-hero-icon")
        hero.append(hero_icon)

        title = Gtk.Label.new("Simple Void Installer")
        title.add_css_class("welcome-title")
        hero.append(title)

        subtitle = Gtk.Label.new(_("Install Void Linux quickly and securely."))
        subtitle.add_css_class("welcome-subtitle")
        hero.append(subtitle)

        container.append(hero)

        # --- STEPS GRID ---
        lbl_steps = Gtk.Label.new(_("Steps"))
        lbl_steps.add_css_class("heading")
        lbl_steps.set_halign(Gtk.Align.START)
        lbl_steps.set_margin_top(10)
        container.append(lbl_steps)

        grid = Gtk.Grid()
        grid.set_column_spacing(20)
        grid.set_row_spacing(20)
        grid.set_column_homogeneous(True)
        
        container.append(grid)

        steps = [
            ("preferences-system-symbolic", _("1. System"), _("Sprache & Zeit")),
            ("system-users-symbolic", _("2. User"), _("User & Hostname")),
            ("drive-harddisk-symbolic", _("3. Partitionen"), _("Laufwerk wählen")),
            ("preferences-other-symbolic", _("4. Modus"), _("Live-Klon oder Netinstall")),
            ("package-x-generic-symbolic", _("5. Software"), _("Desktop & Apps")),
            ("document-edit-symbolic", _("6. Check"), _("Summary")),
            ("system-run-symbolic", _("7. Install"), _("System einrichten")),
        ]

        for i, (icon, title, desc) in enumerate(steps):
            col = i % 2
            row = i // 2
            tile = self._create_tile(icon, title, desc)
            if i == 0:
                # Macht das Tile interaktiv
                click_gesture = Gtk.GestureClick()
                click_gesture.connect("pressed", self._on_tile_clicked)
                tile.add_controller(click_gesture)
                
                # Optional: Mauszeiger wird zur Hand, wenn man darüber fährt
                tile.set_cursor(Gdk.Cursor.new_from_name("pointer", None))
                tile.add_css_class("clickable-tile") # Für CSS Hover-Effekt

            grid.attach(tile, col, row, 1, 1)

        # --- CREDITS ---
        credits_box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=16)
        credits_box.set_halign(Gtk.Align.CENTER)
        credits_box.set_margin_top(40)
        credits_box.set_margin_bottom(20)

        credits_text = Gtk.Label.new(_("Created by @LinuxNation & @Pinguin-TV"))
        credits_text.add_css_class("dim-label")
        credits_box.append(credits_text)

        logos_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=32)
        logos_box.set_halign(Gtk.Align.CENTER)
        credits_box.append(logos_box)

        base_dir = os.path.dirname(os.path.abspath(__file__))
        icon_path_1 = os.path.join(base_dir, "icons", "linuxnation.png")
        icon_path_2 = os.path.join(base_dir, "icons", "pinguin.png")
        LOGO_SIZE = 96 

        if os.path.exists(icon_path_1):
            img1 = Gtk.Image.new_from_file(icon_path_1)
            img1.set_pixel_size(LOGO_SIZE) 
            logos_box.append(img1)
        
        if os.path.exists(icon_path_2):
            img2 = Gtk.Image.new_from_file(icon_path_2)
            img2.set_pixel_size(LOGO_SIZE)
            logos_box.append(img2)

        container.append(credits_box)
        sc.set_child(container)

    def _on_tile_clicked(self, gesture, n_press, x, y):
        if self.on_start_clicked:
            self.on_start_clicked()
            
    def _create_tile(self, icon_name, title_text, desc_text):
        frame = Gtk.Frame()
        frame.add_css_class("step-tile")

        box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=12)
        box.set_margin_top(12)
        box.set_margin_bottom(12)
        box.set_margin_start(12)
        box.set_margin_end(12)
        frame.set_child(box)

        icon = Gtk.Image.new_from_icon_name(icon_name)
        icon.set_pixel_size(32)
        icon.add_css_class("step-tile-icon")
        box.append(icon)

        vbox = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=2)
        vbox.set_valign(Gtk.Align.CENTER)
        
        lbl_title = Gtk.Label.new(title_text)
        lbl_title.set_halign(Gtk.Align.START)
        lbl_title.add_css_class("step-tile-title")
        
        lbl_desc = Gtk.Label.new(desc_text)
        lbl_desc.set_halign(Gtk.Align.START)
        lbl_desc.add_css_class("step-tile-desc")
        lbl_desc.set_wrap(True)
        lbl_desc.set_max_width_chars(25)

        vbox.append(lbl_title)
        vbox.append(lbl_desc)
        
        box.append(vbox)
        return frame
