#!/bin/bash

# Farben für hübsche Ausgaben
GREEN='\033[0;32m'
BLUE='\033[0;34m'
RED='\033[0;31m'
NC='\033[0m' # No Color

echo -e "${BLUE}=== Void Print & Scan Manager Installer ===${NC}"

# 1. Root-Check
if [ "$EUID" -ne 0 ]; then
  echo -e "${RED}Bitte führen Sie dieses Skript als Root aus (sudo ./install.sh)${NC}"
  exit 1
fi

# Prüfen, ob die Python-Datei existiert
if [ ! -f "print-scan.py" ]; then
  echo -e "${RED}Fehler: 'print-scan.py' nicht gefunden!${NC}"
  echo "Bitte führen Sie das Skript in dem Ordner aus, in dem die Python-Datei liegt."
  exit 1
fi

# 2. Abhängigkeiten installieren
echo -e "${BLUE}Installiere notwendige System-Pakete via XBPS...${NC}"
# Wir installieren:
# - GUI: gtk4, libadwaita, python3-gobject, adwaita-icon-theme (wichtig für Icons!)
# - Logic: python3-cups
# - System: cups, sane, avahi, polkit (für Root-Rechte), ufw (optional)
xbps-install -Sy python3-gobject gtk4 libadwaita python3-cups sane cups cups-filters avahi polkit adwaita-icon-theme nss-mdns xdg-utils

if [ $? -ne 0 ]; then
    echo -e "${RED}Fehler bei der Installation der Pakete. Internetverbindung prüfen?${NC}"
    exit 1
fi

# 3. Programm-Dateien kopieren
INSTALL_DIR="/usr/local/bin/print-scan"

echo -e "${BLUE}Kopiere Programmdateien nach $INSTALL_DIR ...${NC}"

# Ordner erstellen, falls nicht existent
mkdir -p "$INSTALL_DIR"

# Datei kopieren
cp print-scan.py "$INSTALL_DIR/print-scan.py"

# Ausführbar machen
chmod +x "$INSTALL_DIR/print-scan.py"

# 4. Desktop-Shortcut erstellen
echo -e "${BLUE}Erstelle Desktop-Eintrag in /usr/share/applications/ ...${NC}"

cat <<EOF > /usr/share/applications/void-print-manager.desktop
[Desktop Entry]
Name=Void Print & Scan Manager
Comment=Drucker und Scanner unter Void Linux einfach einrichten
Exec=/usr/bin/python3 $INSTALL_DIR/print-scan.py
Icon=printer
Terminal=false
Type=Application
Categories=Settings;System;HardwareSettings;
StartupNotify=true
EOF

# 5. Abschluss
echo -e "${GREEN}Installation erfolgreich abgeschlossen!${NC}"
echo "Sie finden die App nun in Ihrem Startmenü unter 'Void Print & Scan Manager'."
echo "Oder starten Sie sie im Terminal mit: python3 $INSTALL_DIR/print-scan.py"
