#!/bin/bash

# ==============================================================================
# Installations-Skript (Self-Contained)
# Führen Sie dieses Skript direkt im Ordner aus, in dem die Dateien liegen.
# ==============================================================================

# Zielverzeichnisse
INSTALL_DIR="/usr/local/bin/software"
APP_DIR="/usr/share/applications"
AUTOSTART_DIR="/etc/xdg/autostart"

# Quellverzeichnis (Der Ordner, in dem dieses Skript liegt)
SOURCE_DIR=$(dirname "$(readlink -f "$0")")

# --- 1. Root-Rechte prüfen ---
if [ "$EUID" -ne 0 ]; then
  echo "Bitte führen Sie dieses Skript mit Root-Rechten aus (sudo ./install.sh)"
  exit 1
fi

# --- 2. Sicherheitscheck ---
# Wir prüfen, ob wir wirklich im richtigen Ordner sind, indem wir schauen,
# ob die Hauptdatei 'software.py' hier liegt.
if [ ! -f "$SOURCE_DIR/software.py" ]; then
    echo "FEHLER: 'software.py' nicht gefunden!"
    echo "Bitte führen Sie dieses Skript in dem Ordner aus, in dem die Programmdateien liegen."
    exit 1
fi

echo "Root-Rechte vorhanden und Verzeichnis korrekt. Installation wird gestartet..."

# --- 3. Bereinigung (Alte Version entfernen) ---
echo ""
echo "--> Schritt 1: Prüfe auf alte Versionen..."

if [ -d "$INSTALL_DIR" ]; then
    echo "Alte Installation in $INSTALL_DIR gefunden. Lösche..."
    rm -rf "$INSTALL_DIR"
else
    echo "Keine alte Installation im Zielverzeichnis gefunden."
fi

# Alte Starter entfernen
rm -f "$APP_DIR/software.desktop"
rm -f "$AUTOSTART_DIR/void-tray.desktop"

# --- 4. Abhängigkeiten installieren ---
echo ""
echo "--> Schritt 2: Installiere notwendige Abhängigkeiten..."
xbps-install -Syu python3 python3-gobject gtk4 libadwaita libayatana-appindicator gtk+3 papirus-icon-theme

if [ $? -ne 0 ]; then
    echo "Fehler bei der Installation der Abhängigkeiten."
    exit 1
fi

# --- 5. Programmdateien kopieren ---
echo ""
echo "--> Schritt 3: Kopiere neue Programmdateien nach $INSTALL_DIR..."

mkdir -p "$INSTALL_DIR"

# Kopiere ALLES aus dem aktuellen Ordner in das Ziel
cp -r "$SOURCE_DIR/"* "$INSTALL_DIR/"

# Aufräumen: Das Installationsskript selbst muss nicht im Zielordner liegen
rm -f "$INSTALL_DIR/install.sh"

if [ $? -ne 0 ]; then
    echo "Fehler beim Kopieren der Dateien."
    exit 1
fi
echo "Dateien erfolgreich kopiert."

# --- 6. Anwendungsstarter (.desktop-Dateien) installieren ---
echo ""
echo "--> Schritt 4: Installiere Anwendungsstarter..."

# 6a. Store Starter (Menü)
# Wir prüfen, ob die Datei im soeben kopierten Zielordner existiert
if [ -f "$INSTALL_DIR/applications/software.desktop" ]; then
    cp "$INSTALL_DIR/applications/software.desktop" "$APP_DIR/"
    echo "Software Store Starter installiert."
else
    echo "WARNUNG: software.desktop fehlt! Erstelle Standard-Starter..."
    # Notfall-Erstellung, falls Datei fehlt
    cat <<EOF > "$APP_DIR/software.desktop"
[Desktop Entry]
Name=Void Software Store
Comment=Softwareverwaltung für Void Linux
Exec=/usr/local/bin/software/software.py
Icon=system-software-install
Terminal=false
Type=Application
Categories=System;
EOF
fi

# 6b. Tray Icon Autostart (Global)
mkdir -p "$AUTOSTART_DIR"

if [ -f "$INSTALL_DIR/applications/void-tray.desktop" ]; then
    cp "$INSTALL_DIR/applications/void-tray.desktop" "$AUTOSTART_DIR/"
    echo "Update Monitor Autostart installiert."
else
    echo "Erstelle void-tray.desktop on-the-fly..."
    cat <<EOF > "$AUTOSTART_DIR/void-tray.desktop"
[Desktop Entry]
Type=Application
Name=Void Update Monitor
Comment=Prüft auf XBPS und Flatpak Updates
Exec=/usr/local/bin/software/void-tray.py
Icon=system-software-update
Terminal=false
Categories=System;Utility;
StartupNotify=false
EOF
fi

# Desktop-Datenbank aktualisieren
update-desktop-database -q

# --- 7. Berechtigungen setzen ---
echo ""
echo "--> Schritt 5: Setze Ausführungsberechtigungen..."

chmod +x "$INSTALL_DIR/software.py"
chmod +x "$INSTALL_DIR/void-tray.py"
chmod 644 "$INSTALL_DIR/apps.json"

# Skripte ausführbar machen
if [ -d "$INSTALL_DIR/scripts" ]; then
    chmod +x "$INSTALL_DIR/scripts/"*.sh
fi

echo "Berechtigungen erfolgreich gesetzt."

# --- Abschluss ---
echo ""
echo "================================================="
echo " Installation erfolgreich! "
echo "================================================="
echo "1. Der Void Software Store ist im Menü verfügbar."
echo "2. Der Update Monitor startet beim nächsten Login."
echo "   (Sofort starten: /usr/local/bin/software/void-tray.py &)"
echo ""

exit 0
