#!/bin/sh

# install.sh - Installationsskript für die Void Linux Benutzerverwaltung

# Beende das Skript sofort, wenn ein Befehl fehlschlägt
set -e

# --- Schritt 1: Auf Root-Rechte prüfen ---
if [ "$(id -u)" -ne 0 ]; then
   echo "Dieses Skript muss als Root ausgeführt werden."
   echo "Bitte versuchen Sie es mit: sudo ./install.sh"
   exit 1
fi

# --- Schritt 2: Abhängigkeiten für Void Linux installieren ---
# - python3: Die Programmiersprache
# - python3-gobject: Python-Bindings für GTK/GObject
# - gtk4: Die GTK4-Bibliothek
# - libadwaita: Die Adwaita-Bibliothek für das moderne Aussehen
# - polkit: Stellt 'pkexec' für die Rechteerweiterung bereit
echo "--> Installiere benötigte Abhängigkeiten..."
xbps-install -Syu python3 python3-gobject gtk4 libadwaita polkit

# --- Schritt 3: Zielverzeichnisse erstellen ---
APP_DIR="/usr/local/bin/user"
ICON_DIR="$APP_DIR/icons" # Korrigiert von /icos zu /icons für Konsistenz

echo "--> Erstelle Verzeichnisse unter /usr/local/bin/..."
mkdir -p "$APP_DIR"
mkdir -p "$ICON_DIR"

# --- Schritt 4: Dateien an die richtigen Orte kopieren ---
echo "--> Kopiere Anwendungsdateien..."

# Hauptskript kopieren
cp -v user.py "$APP_DIR/"

# Icon-Verzeichnis kopieren
# Das -r (rekursiv) ist wichtig, um den ganzen Ordner zu kopieren
cp -v -r icons/* "$ICON_DIR/"

# .desktop-Datei für das Anwendungsmenü kopieren
install -Dm644 user.desktop /usr/share/applications/user.desktop

# --- Schritt 5: Berechtigungen setzen ---
echo "--> Setze Ausführungsrechte für das Hauptskript..."
chmod +x "$APP_DIR/user.py"

# --- Abschluss ---
echo ""
echo "#####################################################"
echo "#                                                   #"
echo "#    Installation erfolgreich abgeschlossen!        #"
echo "#                                                   #"
echo "#####################################################"
echo ""
echo "Du solltest die 'Benutzerverwaltung' jetzt in deinem Anwendungsmenü finden."
echo "Wenn nicht, musst du dich eventuell neu anmelden oder 'sudo update-desktop-database' ausführen."
