#!/bin/sh

# uninstall.sh - Deinstallationsskript für die Void Linux Benutzerverwaltung

# Beende das Skript sofort, wenn ein Befehl fehlschlägt
set -e

# --- Schritt 1: Auf Root-Rechte prüfen ---
if [ "$(id -u)" -ne 0 ]; then
   echo "Dieses Skript muss als Root ausgeführt werden."
   echo "Bitte versuchen Sie es mit: sudo ./uninstall.sh"
   exit 1
fi

echo "--> Beginne mit der Deinstallation der Benutzerverwaltung..."

# --- Schritt 2: Dateien löschen ---
# Die -f Option bei 'rm' unterdrückt Fehler, falls eine Datei nicht existiert.
echo "--> Lösche Anwendungsdateien..."
rm -rfv /usr/local/bin/user
rm -fv /usr/share/applications/user.desktop

# --- Schritt 3: Desktop-Datenbank aktualisieren (optional aber empfohlen) ---
echo "--> Aktualisiere die Anwendungsmenü-Datenbank..."
update-desktop-database -q

# --- Abschluss ---
echo ""
echo "#####################################################"
echo "#                                                   #"
echo "#   Deinstallation erfolgreich abgeschlossen!       #"
echo "#                                                   #"
echo "#####################################################"
echo ""
echo "Die Benutzerverwaltung wurde vom System entfernt."
echo "Abhängigkeiten wie python3, gtk4 etc. wurden NICHT entfernt, da sie eventuell von anderen Programmen benötigt werden."
