import gi

gi.require_version("Gtk", "4.0")
from gi.repository import Gtk

__all__ = ["WelcomeView"]


class WelcomeView(Gtk.Box):
    """
    Modernisierte Welcome Page:
    - Hero mit Icon + Titel + Subtitle
    - Step-Liste als "boxed list" mit Icons
    - Warnungen als Card mit Warning-Icon
    """

    def __init__(self):
        super().__init__(orientation=Gtk.Orientation.VERTICAL, spacing=0)

        sc = Gtk.ScrolledWindow()
        sc.set_vexpand(True)
        sc.set_policy(Gtk.PolicyType.NEVER, Gtk.PolicyType.AUTOMATIC)
        self.append(sc)

        container = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=18)
        container.add_css_class("welcome-container")
        for s in (
            container.set_margin_top,
            container.set_margin_bottom,
            container.set_margin_start,
            container.set_margin_end,
        ):
            s(18)

        # --- HERO ---
        hero = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=10)
        hero.set_halign(Gtk.Align.CENTER)
        hero.set_valign(Gtk.Align.START)
        hero.add_css_class("welcome-hero")

        # Symbolic icon from the current icon theme (Adwaita on GNOME etc.)
        hero_icon = Gtk.Image.new_from_icon_name("computer-symbolic")
        hero_icon.set_pixel_size(96)
        hero_icon.add_css_class("welcome-hero-icon")
        hero.append(hero_icon)

        title = Gtk.Label.new("Simple Void Installer")
        title.add_css_class("welcome-title")
        title.set_halign(Gtk.Align.CENTER)
        hero.append(title)

        subtitle = Gtk.Label.new(
            _("Installiere Void Linux schnell und sicher — Schritt für Schritt.")
        )
        subtitle.add_css_class("welcome-subtitle")
        subtitle.set_wrap(True)
        subtitle.set_justify(Gtk.Justification.CENTER)
        subtitle.set_halign(Gtk.Align.CENTER)
        hero.append(subtitle)

        container.append(hero)

        # --- STEPS CARD ---
        steps_frame = Gtk.Frame(label=_("Ablauf"))
        steps_frame.add_css_class("card")
        steps_frame.add_css_class("welcome-card")
        container.append(steps_frame)

        steps_box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=10)
        for s in (
            steps_box.set_margin_top,
            steps_box.set_margin_bottom,
            steps_box.set_margin_start,
            steps_box.set_margin_end,
        ):
            s(14)
        steps_frame.set_child(steps_box)

        # Use a boxed list look
        steps_list = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=0)
        steps_list.add_css_class("boxed-list")
        steps_box.append(steps_list)

        steps = [
            (
                "preferences-system-symbolic",
                _("Systemkonfiguration"),
                _("Sprache, Zeitzone und Tastatur einstellen."),
            ),
            (
                "system-users-symbolic",
                _("Benutzer"),
                _("Benutzer, Hostname sowie Passwörter konfigurieren."),
            ),
            (
                "drive-harddisk-symbolic",
                _("Partitionierung"),
                _("Datenträger auswählen, Partitionen erstellen und formatieren."),
            ),
            (
                "package-x-generic-symbolic",
                _("Software"),
                _("Desktop, Treiber und Zusatzpakete auswählen."),
            ),
            (
                "document-edit-symbolic",
                _("Zusammenfassung"),
                _("Alle Einstellungen prüfen, bevor installiert wird."),
            ),
            (
                "system-run-symbolic",
                _("Installation"),
                _("Basissystem installieren und System konfigurieren."),
            ),
        ]

        for i, (icon_name, t, d) in enumerate(steps, start=1):
            row = self._step_row(i, icon_name, t, d)
            steps_list.append(row)

        # --- WARNING CARD ---
        warn_frame = Gtk.Frame(label=_("Wichtige Hinweise"))
        warn_frame.add_css_class("card")
        warn_frame.add_css_class("welcome-card")
        warn_frame.add_css_class("warning-card")
        container.append(warn_frame)

        warn_box = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=12)
        for s in (
            warn_box.set_margin_top,
            warn_box.set_margin_bottom,
            warn_box.set_margin_start,
            warn_box.set_margin_end,
        ):
            s(14)
        warn_frame.set_child(warn_box)

        warn_icon = Gtk.Image.new_from_icon_name("dialog-warning-symbolic")
        warn_icon.set_pixel_size(28)
        warn_icon.add_css_class("warning-icon")
        warn_box.append(warn_icon)

        warn_text = Gtk.Label.new(
            _("• Die Installation verändert Partitionen und kann Daten löschen.\n"
            "• Erstelle vorher ein Backup wichtiger Dateien.\n"
            "• Für Pakete wird eine Internetverbindung empfohlen.\n"
            "• Sorge für eine stabile Stromversorgung (Netzteil).")
        )
        warn_text.set_wrap(True)
        warn_text.set_halign(Gtk.Align.START)
        warn_text.set_justify(Gtk.Justification.LEFT)
        warn_text.add_css_class("welcome-body")
        warn_box.append(warn_text)

        # --- FOOTER HINT ---
        footer = Gtk.Label.new(_("Tipp: Du kannst in den nächsten Schritten jederzeit zurückgehen."))
        footer.set_halign(Gtk.Align.CENTER)
        footer.set_wrap(True)
        footer.add_css_class("welcome-footer")
        container.append(footer)

        sc.set_child(container)

    def _step_row(self, idx: int, icon_name: str, title: str, desc: str) -> Gtk.Box:
        row = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=12)
        row.add_css_class("welcome-step-row")
        row.set_margin_top(10)
        row.set_margin_bottom(10)
        row.set_margin_start(12)
        row.set_margin_end(12)

        icon = Gtk.Image.new_from_icon_name(icon_name)
        icon.set_pixel_size(24)
        icon.add_css_class("welcome-step-icon")
        row.append(icon)

        text = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=2)
        text.set_hexpand(True)

        t = Gtk.Label.new(f"{idx}. {title}")
        t.set_halign(Gtk.Align.START)
        t.add_css_class("welcome-step-title")

        d = Gtk.Label.new(desc)
        d.set_halign(Gtk.Align.START)
        d.set_wrap(True)
        d.add_css_class("welcome-step-desc")

        text.append(t)
        text.append(d)
        row.append(text)

        return row