import gettext
import os
import sys
import locale
import builtins

# Pfad zu den Übersetzungsdateien (lokal oder systemweit)
if getattr(sys, 'frozen', False):
    # Wenn als Binary gepackt (z.B. mit PyInstaller)
    BASE_DIR = sys._MEIPASS
else:
    # Im Entwicklungsmodus
    BASE_DIR = os.path.dirname(os.path.abspath(__file__))

LOCALE_DIR = os.path.join(BASE_DIR, 'locales')

def setup_language(lang=None):
    """
    Lädt die Sprache. 
    Wenn lang=None, wird die Systemsprache verwendet.
    """
    try:
        if lang:
            # Erzwinge eine Sprache (z.B. "en")
            print(f"Lade Sprache: {lang}")
            t = gettext.translation('svi', localedir=LOCALE_DIR, languages=[lang])
        else:
            # Versuche Systemsprache
            try:
                sys_lang = locale.getdefaultlocale()[0]
            except:
                sys_lang = 'en_US'
            print(f"Lade Systemsprache: {sys_lang}")
            t = gettext.translation('svi', localedir=LOCALE_DIR, languages=[sys_lang], fallback=True)
            
        t.install() # Macht _() global verfügbar im builtins namespace
    except Exception as e:
        print(f"Warnung: Keine Übersetzung gefunden für {lang}: {e}")
        # Fallback: Keine Übersetzung, verwende Text im Code
        # Wir setzen eine Dummy-Funktion in builtins, damit _() nicht crasht
        builtins._ = lambda x: x
