import gi
gi.require_version("Gtk", "4.0")
from gi.repository import Gtk

class CompletionView(Gtk.Box):
    def __init__(self, on_restart_callback, on_exit_callback):
        super().__init__(orientation=Gtk.Orientation.VERTICAL, spacing=20)
        self.set_halign(Gtk.Align.CENTER)
        self.set_valign(Gtk.Align.CENTER)
        for s in [self.set_margin_top, self.set_margin_bottom, self.set_margin_start, self.set_margin_end]:
            s(40)

        self._on_restart_callback = on_restart_callback
        self._on_exit_callback = on_exit_callback

        # 1. Titel & Erfolgstext
        title = Gtk.Label()
        title.set_markup(f"<span font_desc='Sans Bold 24'>{_('Installation successfully completed!')}</span>")
        self.append(title)
        
        self.append(Gtk.Label(label=_("Void Linux has been installed.\nYou can now restart your system.")))

        # 2. Snapper Info (Standardmäßig versteckt)
        self.snapper_frame = Gtk.Frame(label="Btrfs Snapshot Configuration (Snapper)")
        self.snapper_frame.add_css_class("card")
        self.snapper_frame.set_visible(False) # <--- Erstmal unsichtbar
        
        s_box = Gtk.Box(orientation=Gtk.Orientation.VERTICAL, spacing=8)
        s_box.set_margin_top(15); s_box.set_margin_bottom(15); s_box.set_margin_start(15); s_box.set_margin_end(15)
        
        info = Gtk.Label()
        info.set_markup(
            "<b>Snapper is active.</b> Configuration file:\n"
            "<span face='monospace' foreground='#3498db'>/etc/snapper/configs/root</span>\n\n"
            "• <span face='monospace'>TIMELINE_CREATE=\"yes\"</span>: Auto-snapshots enabled.\n"
            "• <span face='monospace'>TIMELINE_LIMIT_HOURLY=\"10\"</span>: Keeps 10 hourly backups."
        )
        info.set_xalign(0); info.set_wrap(True)
        s_box.append(info)
        self.snapper_frame.set_child(s_box)
        self.append(self.snapper_frame)

        # 3. Buttons
        btn_box = Gtk.Box(spacing=15)
        btn_box.set_halign(Gtk.Align.CENTER)
        
        re_btn = Gtk.Button(label=_("Restart System"))
        re_btn.add_css_class("suggested-action")
        re_btn.connect("clicked", self._on_restart_callback)
        
        ex_btn = Gtk.Button(label=_("Exit Installer"))
        ex_btn.connect("clicked", self._on_exit_callback)
        
        btn_box.append(re_btn); btn_box.append(ex_btn)
        self.append(btn_box)

    def show_snapper_info(self, visible: bool):
        """Wird von main.py aufgerufen."""
        self.snapper_frame.set_visible(visible)
