#!/bin/bash

# Farben für Ausgaben
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

echo -e "${GREEN}=== SVI-Installer Installation ===${NC}\n"

# Prüfen ob als root ausgeführt
if [ "$EUID" -ne 0 ]; then 
    echo -e "${RED}Bitte als Root ausführen: sudo ./install.sh${NC}"
    exit 1
fi

# Aktuelles Verzeichnis ermitteln
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

# Abhängigkeiten installieren
echo -e "${YELLOW}Installiere Abhängigkeiten...${NC}"
xbps-install -Sy python3 python3-dbus python3-gobject python3-pyudev libadwaita gtk4

echo -e "${GREEN}✓ Abhängigkeiten installiert${NC}\n"

echo -e "${YELLOW}Kopiere svi-installer nach /opt/svi-installer...${NC}"

# Erstelle Zielverzeichnis falls nicht vorhanden
mkdir -p /opt/svi-installer

# Kopiere kompletten svi-installer Ordner
cp -r "$SCRIPT_DIR"/* /opt/svi-installer/

echo -e "${GREEN}✓ svi-installer kopiert${NC}\n"

# Prüfe ob INCLUDE Ordner existiert
if [ -d "$SCRIPT_DIR/INCLUDE" ]; then
    echo -e "${YELLOW}Kopiere INCLUDE nach /opt/INCLUDE...${NC}"
    mkdir -p /opt/INCLUDE
    cp -r "$SCRIPT_DIR/INCLUDE"/* /opt/INCLUDE/
    echo -e "${GREEN}✓ INCLUDE kopiert${NC}\n"
else
    echo -e "${YELLOW}Warnung: INCLUDE Ordner nicht gefunden, überspringe...${NC}\n"
fi

# Mache main.py ausführbar
if [ -f /opt/svi-installer/main.py ]; then
    chmod +x /opt/svi-installer/main.py
    echo -e "${GREEN}✓ main.py als ausführbar markiert${NC}\n"
fi

echo -e "${GREEN}Installation abgeschlossen!${NC}\n"

# Starte main.py
echo -e "${YELLOW}Starte main.py...${NC}\n"

if [ -f /opt/svi-installer/main.py ]; then
    cd /opt/svi-installer
    python3 /opt/svi-installer/main.py
else
    echo -e "${RED}Fehler: main.py nicht gefunden!${NC}"
    exit 1
fi
