#!/bin/bash

# Farben für die Ausgabe
GREEN='\033[0;32m'
BLUE='\033[0;34m'
RED='\033[0;31m'
NC='\033[0m' # No Color

echo -e "${BLUE}Void Live ISO Creator - Installation${NC}"

# 1. Root-Check
if [ "$EUID" -ne 0 ]; then
  echo -e "${RED}Bitte als Root ausführen (sudo ./install.sh)${NC}"
  exit 1
fi

# 2. Abhängigkeiten installieren (Void Linux XBPS)
echo -e "${GREEN}Schritt 1: Abhängigkeiten werden installiert...${NC}"
xbps-install -Sy python3 \
               python3-gobject \
               gtk4 \
               rsync \
               squashfs-tools \
               grub-i386-efi \
               grub-x86_64-efi \
               xorriso \
               util-linux \
               polkit \
               binutils

# 3. Programm-Ordner kopieren
echo -e "${GREEN}Schritt 2: Kopiere Programmdateien nach /usr/local/bin/...${NC}"
# Falls der Ordner schon existiert, vorher löschen für sauberes Update
rm -rf /usr/local/bin/void-live-creator
cp -r void-live-creator /usr/local/bin/

# Berechtigungen setzen (Ausführbar machen)
chmod +x /usr/local/bin/void-live-creator/main.py

# 4. Desktop-Datei installieren
echo -e "${GREEN}Schritt 3: Installiere Desktop-Verknüpfung...${NC}"
cp /usr/local/bin/void-live-creator/live-creator.desktop /usr/share/applications/

# Sicherstellen, dass der Pfad in der .desktop Datei korrekt ist
# Wir biegen den Exec-Pfad automatisch auf den Installationsort um
sed -i 's|Exec=.*|Exec=python3 /usr/local/bin/void-live-creator/main.py|' /usr/share/applications/live-creator.desktop

# 5. Abschluss
echo -e "${BLUE}-------------------------------------------------------${NC}"
echo -e "${GREEN}Installation abgeschlossen!${NC}"
echo -e "Du findest das Tool jetzt in deinem Anwendungsmenü."
echo -e "${BLUE}-------------------------------------------------------${NC}"