#!/bin/bash

set -e

# --- KONFIG ---
APP_NAME="vstore"
SRC_DIR="$(cd "$(dirname "$0")" && pwd)"
TARGET_DIR="/opt/vstore"
DESKTOP_FILE="vstore.desktop"

# --- CHECK ROOT ---
if [[ $EUID -ne 0 ]]; then
    echo "❌ Bitte als root ausführen (sudo ./install.sh)"
    exit 1
fi

echo "📦 Installation von $APP_NAME startet..."

# --- ABHÄNGIGKEITEN ---
DEPENDENCIES=(
    fzf
    bash
    coreutils
    util-linux
)

echo "🔍 Prüfe Abhängigkeiten..."
for pkg in "${DEPENDENCIES[@]}"; do
    if ! xbps-query -p pkgver "$pkg" &>/dev/null; then
        echo "➡️  Installiere $pkg"
        xbps-install -Sy "$pkg"
    else
        echo "✔ $pkg bereits installiert"
    fi
done

# --- /OPT VERZEICHNIS ---
echo "📁 Kopiere Programm nach $TARGET_DIR"
mkdir -p /opt
rm -rf "$TARGET_DIR"
cp -r "$SRC_DIR" "$TARGET_DIR"

# --- EXEC RECHTE ---
echo "🔧 Setze Ausführungsrechte für vstore.sh"
chmod +x "$TARGET_DIR/vstore.sh"

# --- DESKTOP DATEI ---
if [[ -f "$SRC_DIR/$DESKTOP_FILE" ]]; then
    echo "🖥️  Installiere Desktop-Datei"
    cp "$SRC_DIR/$DESKTOP_FILE" /usr/share/applications/
    chmod 644 "/usr/share/applications/$DESKTOP_FILE"
else
    echo "⚠️  Warnung: $DESKTOP_FILE nicht gefunden"
fi

# --- CACHE AKTUALISIEREN ---
echo "🔄 Aktualisiere Desktop-Datenbank"
command -v update-desktop-database &>/dev/null && update-desktop-database /usr/share/applications || true

echo
echo "✅ $APP_NAME wurde erfolgreich installiert!"
echo "➡️  Start: Menü oder /opt/vstore/vstore.sh"

